import { defineConfig } from "eslint/config";
import typescriptEslint from "@typescript-eslint/eslint-plugin";
import tsParser from "@typescript-eslint/parser";
import path from "node:path";
import { fileURLToPath } from "node:url";
import js from "@eslint/js";
import { FlatCompat } from "@eslint/eslintrc";


const __filename = fileURLToPath( import.meta.url );
const __dirname = path.dirname( __filename );
const compat = new FlatCompat( {
    baseDirectory: __dirname,
    recommendedConfig: js.configs.recommended,
    allConfig: js.configs.all
} );

export default defineConfig( [ {
    extends: compat.extends( "eslint:recommended", "plugin:@typescript-eslint/recommended" ),

    ignores: [ "dist/**", "node_modules/**", "build/**", "**/*.js" ],

    plugins: {
        "@typescript-eslint": typescriptEslint,
    },

    languageOptions: {
        parser: tsParser,
        parserOptions: {
            ecmaVersion: "2022",
            sourceType: "module",
        },
    },

    rules: {
        "@typescript-eslint/no-unused-vars": [ "error" ],
        "@typescript-eslint/no-namespace": "off",
        "@typescript-eslint/no-explicit-any": "off",
        "@typescript-eslint/no-unsafe-function-type": "off",
        "no-debugger": "off",
        "prefer-spread": "off",
    },
} ] );